'*************************************************************
' 
' ADOBE SYSTEMS INCORPORATED 
' Copyright 2005-2010 Adobe Systems Incorporated 
' All Rights Reserved 

' NOTICE:  Adobe permits you to use, modify, and 
' distribute this file in accordance with the terms
' of the Adobe license agreement accompanying it.  
' If you have received this file from a source 
' other than Adobe, then your use, modification,
' or distribution of it requires the prior 
' written permission of Adobe. 
' 
'*************************************************************

' CycleGraph.vbs

' DESCRIPTION

' This sample accepts radius and step values from the developer
' and draws a cyclic graph figure from it. 
' To draw different objects try the values given in the 
' Examples1.ai file.
' 
'*************************************************************

' Create the general AI objects
Set appObj = CreateObject("Illustrator.Application")
Set docObj = appObj.Documents.Add

' Set the document properties
docObj.DefaultFilled = False
docObj.DefaultStroked = True
pathWidth = 1
docObj.DefaultStrokeWidth = pathWidth
pathOpacity = 100

Set groupObj = docObj.ActiveLayer.GroupItems.Add

myMsg = "alert(""Values used to draw the CycleGraph: Big Radius - 100, Small Radius - 35, Pen Distance - 30, Points/Cycle - 50, Cycles - 7. Change values in the script to draw different objects."")"

appObj.DoJavaScript myMsg

' Change values here to create different objects from Examples1.ai
bigRadius = 100
smallRadius = 35
penDistance = 30
stepsPerCycle = 50
cycles = 7

' OR
' Get the values from the user
' bigRadius = InputBox("Enter Big Radius", "CycleGraph", 100)
' smallRadius = InputBox("Enter Small Radius", "CycleGraph", 35)
' penDistance = InputBox("Enter Pen Distance", "CycleGraph", 30)
' stepsPerCycle = InputBox("Enter Points/Cycle", "CycleGraph", 50)
' cycles = InputBox("Enter Cycles", "CycleGraph", 7)

' set center of large circle at middle of page
docWidth = docObj.Width
docHeight = docObj.Height
BigX = docWidth / 2
BigY = docHeight / 2

' set small circle at top of large circle
SmallX = BigX
SmallY = BigY + bigRadius - smallRadius
radiusDifference = bigRadius - smallRadius

' initial angles
alphaAngle = 0
betaAngle = 0

' initialize pi value, step sizes
pi = 4 * Atn(1)
bigStepSize = (2 * pi) / stepsPerCycle
smallStepSize = bigStepSize * bigRadius / smallRadius

' initialize trailing point
prevX = SmallX
prevY = SmallY + penDistance
' for each step
For i = 0 To stepsPerCycle * cycles
    alphaAngle = alphaAngle + bigStepSize
    betaAngle = betaAngle - smallStepSize
    SmallX = BigX + (radiusDifference * Sin(alphaAngle))
    SmallY = BigY + (radiusDifference * Cos(alphaAngle))
    X = SmallX + (penDistance * Sin(betaAngle))
    Y = SmallY + (penDistance * Cos(betaAngle))
    CreateLine groupObj, prevX, prevY, X, Y, pathOpacity
    prevX = X
    prevY = Y
Next

' ****************************************************************

' Factor inToFactor into the array outArray

Private Function Factor(inToFactor, outArray())
	
	If (inToFactor > 1) Then
	    ReDim outArray(Sqr(inToFactor))
	    factorCount = 0
	    toFactor = inToFactor
	    ' Factor out all powers of 2
	    Do While ((toFactor Mod 2) = 0)
		outArray(factorCount) = 2
		factorCount = factorCount + 1
		toFactor = toFactor / 2
	    Loop
	    limit = toFactor
	    ' Walk through the odd numbers, testing each one
	    For testFactor = 3 To limit Step 2
		Do While ((toFactor Mod testFactor) = 0)
		    outArray(factorCount) = testFactor
		    factorCount = factorCount + 1
		    toFactor = toFactor / testFactor
		Loop
	    Next
	    ReDim Preserve outArray(factorCount - 1)
	    Factor = factorCount - 1
	Else
	    ' if number to factor is less than 1, return single factor 1
	    ReDim outArray(1)
	    factorCount = 0
	    outArray(0) = 1
	    Factor = 0
	End If
	
End Function

' ****************************************************************

' Calculate the cycles using the radii entered

Private Sub CalculateCycles
	
	' The required number of cycles (times around the Big circle) is
	' determined by the largest common multiple of the radii of the
	' Big and Small circles
	If (StrComp(bigRadiusText.Text, "") And StrComp(smallRadiusText.Text, "")) Then
	    toFactor1 = bigRadiusText.Text
	    toFactor2 = smallRadiusText.Text

	    ' Get the factors of each radius
	   
	    factors1 = Factor(toFactor1, factor1List)
	    factors2 = Factor(toFactor2, factor2List)

	    ' Cross off all factors held in common
	    For i = 0 To factors2
		For j = 0 To factors1
		    If (factor1List(j) = factor2List(i)) Then
			factor1List(j) = 1
			factor2List(i) = 1
		    End If
		Next
	    Next
	    cycles = 1
	    ' and multiply together all remaining factors in the small radius
	    For i = 0 To factors2
		cycles = cycles * factor2List(i)
	    Next
	    ' to determine the number of cycles
	    cyclesText.Text = cycles
	End If

End Sub

' ****************************************************************

' Create the path items

Private Sub CreateLine(inGroupItem, inStartX, inStartY, inEndX, inEndY, inOpacity)
	
	Set pathItem = inGroupItem.PathItems.Add
	pathItem.SetEntirePath Array(Array(inStartX, inStartY), Array(inEndX, inEndY))
	pathItem.Opacity = inOpacity

End Sub

' ****************************************************************

' Calculate the required number of cycles every time the Big radius is changed

Private Sub bigRadiusText_Change
	
	CalculateCycles

End Sub

' ****************************************************************

' Calculate the required number of cycles every time the Small radius is changed

Private Sub smallRadiusText_Change
	
	CalculateCycles

End Sub



'' SIG '' Begin signature block
'' SIG '' MIIY1QYJKoZIhvcNAQcCoIIYxjCCGMICAQExCzAJBgUr
'' SIG '' DgMCGgUAMGcGCisGAQQBgjcCAQSgWTBXMDIGCisGAQQB
'' SIG '' gjcCAR4wJAIBAQQQTvApFpkntU2P5azhDxfrqwIBAAIB
'' SIG '' AAIBAAIBAAIBADAhMAkGBSsOAwIaBQAEFLOSR+6QqZQl
'' SIG '' d65lljUeS2rfifN0oIITuzCCA+4wggNXoAMCAQICEH6T
'' SIG '' 6/t8xk5Z6kuad9QG/DswDQYJKoZIhvcNAQEFBQAwgYsx
'' SIG '' CzAJBgNVBAYTAlpBMRUwEwYDVQQIEwxXZXN0ZXJuIENh
'' SIG '' cGUxFDASBgNVBAcTC0R1cmJhbnZpbGxlMQ8wDQYDVQQK
'' SIG '' EwZUaGF3dGUxHTAbBgNVBAsTFFRoYXd0ZSBDZXJ0aWZp
'' SIG '' Y2F0aW9uMR8wHQYDVQQDExZUaGF3dGUgVGltZXN0YW1w
'' SIG '' aW5nIENBMB4XDTEyMTIyMTAwMDAwMFoXDTIwMTIzMDIz
'' SIG '' NTk1OVowXjELMAkGA1UEBhMCVVMxHTAbBgNVBAoTFFN5
'' SIG '' bWFudGVjIENvcnBvcmF0aW9uMTAwLgYDVQQDEydTeW1h
'' SIG '' bnRlYyBUaW1lIFN0YW1waW5nIFNlcnZpY2VzIENBIC0g
'' SIG '' RzIwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIB
'' SIG '' AQCxrLNJVEuXHBIK2CV5kSJXKm/cuCbEQ3Nrwr8uUFr7
'' SIG '' FMJ2jkMBJUO0oeJF9Oi3e8N0zCLXtJQAAvdN7b+0t0Qk
'' SIG '' a81fRTvRRM5DEnMXgotptCvLmR6schsmTXEfsTHd+1Fh
'' SIG '' AlOmqvVJLAV4RaUvic7nmef+jOJXPz3GktxK+Hsz5HkK
'' SIG '' +/B1iEGc/8UDUZmq12yfk2mHZSmDhcJgFMTIyTsU2sCB
'' SIG '' 8B8NdN6SIqvK9/t0fCfm90obf6fDni2uiuqm5qonFn1h
'' SIG '' 95hxEbziUKFL5V365Q6nLJ+qZSDT2JboyHylTkhE/xni
'' SIG '' RAeSC9dohIBdanhkRc1gRn5UwRN8xXnxycFxAgMBAAGj
'' SIG '' gfowgfcwHQYDVR0OBBYEFF+a9W5czMx0mtTdfe8/2+xM
'' SIG '' gC7dMDIGCCsGAQUFBwEBBCYwJDAiBggrBgEFBQcwAYYW
'' SIG '' aHR0cDovL29jc3AudGhhd3RlLmNvbTASBgNVHRMBAf8E
'' SIG '' CDAGAQH/AgEAMD8GA1UdHwQ4MDYwNKAyoDCGLmh0dHA6
'' SIG '' Ly9jcmwudGhhd3RlLmNvbS9UaGF3dGVUaW1lc3RhbXBp
'' SIG '' bmdDQS5jcmwwEwYDVR0lBAwwCgYIKwYBBQUHAwgwDgYD
'' SIG '' VR0PAQH/BAQDAgEGMCgGA1UdEQQhMB+kHTAbMRkwFwYD
'' SIG '' VQQDExBUaW1lU3RhbXAtMjA0OC0xMA0GCSqGSIb3DQEB
'' SIG '' BQUAA4GBAAMJm495739ZMKrvaLX64wkdu0+CBl03X6ZS
'' SIG '' nxaN6hySCURu9W3rWHww6PlpjSNzCxJvR6muORH4KrGb
'' SIG '' sBrDjutZlgCtzgxNstAxpghcKnr84nodV0yoZRjpeUBi
'' SIG '' JZZux8c3aoMhCI5B6t3ZVz8dd0mHKhYGXqY4aiISo1EZ
'' SIG '' g362MIIEozCCA4ugAwIBAgIQDs/0OMj+vzVuBNhqmBsa
'' SIG '' UDANBgkqhkiG9w0BAQUFADBeMQswCQYDVQQGEwJVUzEd
'' SIG '' MBsGA1UEChMUU3ltYW50ZWMgQ29ycG9yYXRpb24xMDAu
'' SIG '' BgNVBAMTJ1N5bWFudGVjIFRpbWUgU3RhbXBpbmcgU2Vy
'' SIG '' dmljZXMgQ0EgLSBHMjAeFw0xMjEwMTgwMDAwMDBaFw0y
'' SIG '' MDEyMjkyMzU5NTlaMGIxCzAJBgNVBAYTAlVTMR0wGwYD
'' SIG '' VQQKExRTeW1hbnRlYyBDb3Jwb3JhdGlvbjE0MDIGA1UE
'' SIG '' AxMrU3ltYW50ZWMgVGltZSBTdGFtcGluZyBTZXJ2aWNl
'' SIG '' cyBTaWduZXIgLSBHNDCCASIwDQYJKoZIhvcNAQEBBQAD
'' SIG '' ggEPADCCAQoCggEBAKJjCzlEuLsjp0RJuw7/ofBhClOT
'' SIG '' sJjbrSwPSsVu/4Y8U1UPFc4EPyv9qZaW2b5heQtbyUyG
'' SIG '' duXgQ0sile7CK0PBn9hotI5AT+6FOLkRxSPyZFjwFTJv
'' SIG '' TlehroikAtcqHs1L4d1j1ReJMluwXplaqJ0oUA4X7pbb
'' SIG '' YTtFUR3PElYLkkf8q672Zj1HrHBy55LnX80QucSDZJQZ
'' SIG '' vSWA4ejSIqXQugJ6oXeTW2XD7hd0vEGGKtwITIySjJEt
'' SIG '' nndEH2jWqHR32w5bMotWizO92WPISZ06xcXqMwvS8aMb
'' SIG '' 9Iu+2bNXizveBKd6IrIkri7HcMW+ToMmCPsLvalPmQjh
'' SIG '' EChyqs0CAwEAAaOCAVcwggFTMAwGA1UdEwEB/wQCMAAw
'' SIG '' FgYDVR0lAQH/BAwwCgYIKwYBBQUHAwgwDgYDVR0PAQH/
'' SIG '' BAQDAgeAMHMGCCsGAQUFBwEBBGcwZTAqBggrBgEFBQcw
'' SIG '' AYYeaHR0cDovL3RzLW9jc3Aud3Muc3ltYW50ZWMuY29t
'' SIG '' MDcGCCsGAQUFBzAChitodHRwOi8vdHMtYWlhLndzLnN5
'' SIG '' bWFudGVjLmNvbS90c3MtY2EtZzIuY2VyMDwGA1UdHwQ1
'' SIG '' MDMwMaAvoC2GK2h0dHA6Ly90cy1jcmwud3Muc3ltYW50
'' SIG '' ZWMuY29tL3Rzcy1jYS1nMi5jcmwwKAYDVR0RBCEwH6Qd
'' SIG '' MBsxGTAXBgNVBAMTEFRpbWVTdGFtcC0yMDQ4LTIwHQYD
'' SIG '' VR0OBBYEFEbGaaMOShQe1UzaUmMXP142vA3mMB8GA1Ud
'' SIG '' IwQYMBaAFF+a9W5czMx0mtTdfe8/2+xMgC7dMA0GCSqG
'' SIG '' SIb3DQEBBQUAA4IBAQB4O7SRKgBM8I9iMDd4o4QnB28Y
'' SIG '' st4l3KDUlAOqhk4ln5pAAxzdzuN5yyFoBtq2MrRtv/Qs
'' SIG '' JmMz5ElkbQ3mw2cO9wWkNWx8iRbG6bLfsundIMZxD82V
'' SIG '' dNy2XN69Nx9DeOZ4tc0oBCCjqvFLxIgpkQ6A0RH83Vx2
'' SIG '' bk9eDkVGQW4NsOo4mrE62glxEPwcebSAe6xp9P2ctgwW
'' SIG '' K/F/Wwk9m1viFsoTgW0ALjgNqCmPLOGy9FqpAa8VnCwv
'' SIG '' SRvbIrvD/niUUcOGsYKIXfA9tFGheTMrLnu53CAJE3Hr
'' SIG '' ahlbz+ilMFcsiUk/uc9/yb8+ImhjU5q9aXSsxR08f5Lg
'' SIG '' w7wc2AR1MIIFVjCCBD6gAwIBAgIQGRoyy3Wcl7jPrBGN
'' SIG '' 1RJ/STANBgkqhkiG9w0BAQsFADCByjELMAkGA1UEBhMC
'' SIG '' VVMxFzAVBgNVBAoTDlZlcmlTaWduLCBJbmMuMR8wHQYD
'' SIG '' VQQLExZWZXJpU2lnbiBUcnVzdCBOZXR3b3JrMTowOAYD
'' SIG '' VQQLEzEoYykgMjAwNiBWZXJpU2lnbiwgSW5jLiAtIEZv
'' SIG '' ciBhdXRob3JpemVkIHVzZSBvbmx5MUUwQwYDVQQDEzxW
'' SIG '' ZXJpU2lnbiBDbGFzcyAzIFB1YmxpYyBQcmltYXJ5IENl
'' SIG '' cnRpZmljYXRpb24gQXV0aG9yaXR5IC0gRzUwHhcNMTQw
'' SIG '' MzA0MDAwMDAwWhcNMjQwMzAzMjM1OTU5WjCBkTELMAkG
'' SIG '' A1UEBhMCVVMxHTAbBgNVBAoTFFN5bWFudGVjIENvcnBv
'' SIG '' cmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBUcnVzdCBO
'' SIG '' ZXR3b3JrMUIwQAYDVQQDEzlTeW1hbnRlYyBDbGFzcyAz
'' SIG '' IEV4dGVuZGVkIFZhbGlkYXRpb24gQ29kZSBTaWduaW5n
'' SIG '' IENBIC0gRzIwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAw
'' SIG '' ggEKAoIBAQDQGALu7aKNCFhjDybX3SJ7iPbkx+w7Jhh4
'' SIG '' 08ekIFONg3ylP36lyCtH3w31ptnDHSWTYM983OoDLL54
'' SIG '' f1xIbacC2Un4oevrmmF8n8Am1twV2LgQfCC6XvQo9qjq
'' SIG '' p1x8xpyQkDQ8tiKs/roMOh7WXoS2W/CjgXB4io1GUnv8
'' SIG '' 20nzKRMRdE+NFrPC46AtxwMEnczDcuEODPsCjvEmF3tu
'' SIG '' rvi3M4umYUtF3/IlRMf3sJgjNtwoeQrom3KIqNjornt/
'' SIG '' CmRFpfBXkpp3BkUe65/oZvN6fZKBXwAtHrj2VhNaYg23
'' SIG '' R6GPcu+DXoLglJjhrKWthjfgp9O6sT5660Wo8cFEfeID
'' SIG '' AgMBAAGjggFtMIIBaTASBgNVHRMBAf8ECDAGAQH/AgEA
'' SIG '' MC8GA1UdHwQoMCYwJKAioCCGHmh0dHA6Ly9zLnN5bWNi
'' SIG '' LmNvbS9wY2EzLWc1LmNybDAWBgNVHSUBAf8EDDAKBggr
'' SIG '' BgEFBQcDAzAOBgNVHQ8BAf8EBAMCAQYwLgYIKwYBBQUH
'' SIG '' AQEEIjAgMB4GCCsGAQUFBzABhhJodHRwOi8vcy5zeW1j
'' SIG '' ZC5jb20wXwYDVR0gBFgwVjBUBgRVHSAAMEwwIwYIKwYB
'' SIG '' BQUHAgEWF2h0dHBzOi8vZC5zeW1jYi5jb20vY3BzMCUG
'' SIG '' CCsGAQUFBwICMBkaF2h0dHBzOi8vZC5zeW1jYi5jb20v
'' SIG '' cnBhMCkGA1UdEQQiMCCkHjAcMRowGAYDVQQDExFTeW1h
'' SIG '' bnRlY1BLSS0xLTYyOTAdBgNVHQ4EFgQUFmbeSjTjUKcR
'' SIG '' hgOxbKnGrM1ZbpswHwYDVR0jBBgwFoAUf9Nlp8Ld7Lvw
'' SIG '' MAnzQzn6Aq8zMTMwDQYJKoZIhvcNAQELBQADggEBAD9b
'' SIG '' GfP6E9V1OCpa7p9aoEypHcXMlO7eFf71EG6kG6Vkg1QY
'' SIG '' WMQLKKGFw0505f+JfP7V7Ty6cZ9WAiaPFiqI/rCjJyLO
'' SIG '' S+I4jgCmOoZfneU+qN5kSUF0QSH9B8iEF9odZTCCyyZP
'' SIG '' OdYEJ6SBsUtJwyOLfgIyGCe3qwvzGHK2pO5nBm84pliN
'' SIG '' 4PF+XaRgxqjlUF/g6Lrij5lYtrWgqHbxovEciEFyflKX
'' SIG '' mwo2mY1Q9wHrPOfwImrlNYxjNooasdlnZl+XGu+oIJ3w
'' SIG '' L7psztmUhQDxWPF9yXwitQddAsbmC7+rk5P/JxiOMzZ+
'' SIG '' VzTxw68EwYTxVrPoh4M2+NMKMdxuLG0wggXEMIIErKAD
'' SIG '' AgECAhAeObM6nEaakCI61S77g784MA0GCSqGSIb3DQEB
'' SIG '' CwUAMIGRMQswCQYDVQQGEwJVUzEdMBsGA1UEChMUU3lt
'' SIG '' YW50ZWMgQ29ycG9yYXRpb24xHzAdBgNVBAsTFlN5bWFu
'' SIG '' dGVjIFRydXN0IE5ldHdvcmsxQjBABgNVBAMTOVN5bWFu
'' SIG '' dGVjIENsYXNzIDMgRXh0ZW5kZWQgVmFsaWRhdGlvbiBD
'' SIG '' b2RlIFNpZ25pbmcgQ0EgLSBHMjAeFw0xNTExMDYwMDAw
'' SIG '' MDBaFw0xNzEwMjgyMzU5NTlaMIIBDjETMBEGCysGAQQB
'' SIG '' gjc8AgEDEwJVUzEZMBcGCysGAQQBgjc8AgECFAhEZWxh
'' SIG '' d2FyZTEdMBsGA1UEDxMUUHJpdmF0ZSBPcmdhbml6YXRp
'' SIG '' b24xEDAOBgNVBAUTBzI3NDgxMjkxCzAJBgNVBAYTAlVT
'' SIG '' MRMwEQYDVQQIDApDYWxpZm9ybmlhMREwDwYDVQQHDAhT
'' SIG '' YW4gSm9zZTEjMCEGA1UECgwaQWRvYmUgU3lzdGVtcyBJ
'' SIG '' bmNvcnBvcmF0ZWQxLDAqBgNVBAsMI0lsbHVzdHJhdG9y
'' SIG '' LCBJbkRlc2lnbiwgSW5Db3B5LCBNdXNlMSMwIQYDVQQD
'' SIG '' FBpBZG9iZSBTeXN0ZW1zIEluY29ycG9yYXRlZDCCASIw
'' SIG '' DQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAJpOMyAj
'' SIG '' 8r+7FuNs3MXed0OMajoJnoF4v8cV+9drUVII+pzb6yeV
'' SIG '' GdBTt8U03rk1a2V51gcTHAorQxs2plJIgafn/pqMzG7f
'' SIG '' 9FZui7WiMOuyif/0joytDGujeQd7xQ/23YYtZpQQ/ahz
'' SIG '' VI4Pzv44FVDGwHYfGxGaQ127Bqp5EhLX7zwFiGEPnP3V
'' SIG '' R4ZyQn2WQeA0a68KuhD6anNHize0XjSBFelrNhN4uYpk
'' SIG '' prXyGv8vKdq9a911iY/efPsRueUPYucYJCF/lBt3DaR4
'' SIG '' J/FeaSJeijyllNwAqu7XY7Jl9zB0duRLlRFpGJeCymhY
'' SIG '' 3wvU6039CHBnrYIXZ/ldAWUpz+MCAwEAAaOCAZYwggGS
'' SIG '' MC4GA1UdEQQnMCWgIwYIKwYBBQUHCAOgFzAVDBNVUy1E
'' SIG '' RUxBV0FSRS0yNzQ4MTI5MAkGA1UdEwQCMAAwKwYDVR0f
'' SIG '' BCQwIjAgoB6gHIYaaHR0cDovL3N3LnN5bWNiLmNvbS9z
'' SIG '' dy5jcmwwFgYDVR0lAQH/BAwwCgYIKwYBBQUHAwMwDgYD
'' SIG '' VR0PAQH/BAQDAgeAMGYGA1UdIARfMF0wWwYLYIZIAYb4
'' SIG '' RQEHFwYwTDAjBggrBgEFBQcCARYXaHR0cHM6Ly9kLnN5
'' SIG '' bWNiLmNvbS9jcHMwJQYIKwYBBQUHAgIwGQwXaHR0cHM6
'' SIG '' Ly9kLnN5bWNiLmNvbS9ycGEwHQYDVR0OBBYEFPsxU7iZ
'' SIG '' MQ82sRMZZ9wcUZpCtgBaMFgGCCsGAQUFBwEBBEwwSjAf
'' SIG '' BggrBgEFBQcwAYYTaHR0cDovL3N3LnN5bWNkLmNvbTAn
'' SIG '' BggrBgEFBQcwAoYbaHR0cDovL3N3MS5zeW1jYi5jb20v
'' SIG '' c3cuY3J0MB8GA1UdIwQYMBaAFBZm3ko041CnEYYDsWyp
'' SIG '' xqzNWW6bMA0GCSqGSIb3DQEBCwUAA4IBAQBQEAjwXAas
'' SIG '' FygBRU/4fmAgJdTZDZFT/Gri5Vi28b6iHzDnTKcr3QTJ
'' SIG '' 33Ql9LbIi2CjtnD1n0zyvIdjXDXFLcbeMoQQ9L5XuiRw
'' SIG '' kwUPpRrLYsNPQ8G3n7N/me223Sw4noAy0ErrUNZd4Bew
'' SIG '' mTc3hn/95O1LC9QuGNFv/l+RyyFXBe3iJvHOpMBwIkMa
'' SIG '' OXB5/2FbFLqqELV4zWE2GXHhxfgxTgHHww1pJNBdPpxR
'' SIG '' qIjQxmgkL24azZZyxxtRWI6mpgCu+/4ZeXzwKSMycBYc
'' SIG '' gVG9c5TUSh+s1a4HPrrBJ1lPJQ+8+v3rc6ytjZXAC/g8
'' SIG '' GhhIrxvatjLMNWzrFNG7iEciMYIEhjCCBIICAQEwgaYw
'' SIG '' gZExCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
'' SIG '' YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMg
'' SIG '' VHJ1c3QgTmV0d29yazFCMEAGA1UEAxM5U3ltYW50ZWMg
'' SIG '' Q2xhc3MgMyBFeHRlbmRlZCBWYWxpZGF0aW9uIENvZGUg
'' SIG '' U2lnbmluZyBDQSAtIEcyAhAeObM6nEaakCI61S77g784
'' SIG '' MAkGBSsOAwIaBQCggaYwGQYJKoZIhvcNAQkDMQwGCisG
'' SIG '' AQQBgjcCAQQwHAYKKwYBBAGCNwIBCzEOMAwGCisGAQQB
'' SIG '' gjcCARUwIwYJKoZIhvcNAQkEMRYEFKBEin4PDo9A1ZiC
'' SIG '' 7jcGZemXNd4JMEYGCisGAQQBgjcCAQwxODA2oDSAMgBB
'' SIG '' AGQAbwBiAGUAIABJAGwAbAB1AHMAdAByAGEAdABvAHIA
'' SIG '' IABDAEMAIAAyADAAMQA1MA0GCSqGSIb3DQEBAQUABIIB
'' SIG '' AJkprU/1B4174UGJavTY+fGSEyooaCxnze9+Ki2NUohJ
'' SIG '' b++rFQ6W+MiFnU4KzPON1vz+rpfpyrYF9hQBQFxe7EW6
'' SIG '' T/Uck5UACi1mC4o3Hqaxt34ZPyZ5LEiiQKavHrbFoS5O
'' SIG '' caRHho+ek6v+l4FP4WSXklP0Hw53MN2SJaiRA/eXSrFi
'' SIG '' HsZjFI6s9Pgjj/GQRc9OYEpFoZC++7zSswdmAWFTm5nf
'' SIG '' qZC9VN7ybDI015ymfBV0/YBXg1w2ieyxD9omaSmXlGFp
'' SIG '' eGMl4AlCo7HmyUv1zSIG9olYGjBaUbAOBFdXUowcTwf3
'' SIG '' wOV/q5ZWanedsfp2eNS2ROpveMnvr+5mScOhggILMIIC
'' SIG '' BwYJKoZIhvcNAQkGMYIB+DCCAfQCAQEwcjBeMQswCQYD
'' SIG '' VQQGEwJVUzEdMBsGA1UEChMUU3ltYW50ZWMgQ29ycG9y
'' SIG '' YXRpb24xMDAuBgNVBAMTJ1N5bWFudGVjIFRpbWUgU3Rh
'' SIG '' bXBpbmcgU2VydmljZXMgQ0EgLSBHMgIQDs/0OMj+vzVu
'' SIG '' BNhqmBsaUDAJBgUrDgMCGgUAoF0wGAYJKoZIhvcNAQkD
'' SIG '' MQsGCSqGSIb3DQEHATAcBgkqhkiG9w0BCQUxDxcNMTYw
'' SIG '' MTE0MjMxNTA0WjAjBgkqhkiG9w0BCQQxFgQU17V7/G2U
'' SIG '' EcaF3BmWx0CrtY7NUbcwDQYJKoZIhvcNAQEBBQAEggEA
'' SIG '' aax5OJ2NfKKvBmPyqOuABwCmN6w2Rrvq6UjlQqw4tOn2
'' SIG '' fhiBttGmNJv5/ctfE6PXSGDoXhC+wASPE3FwbgCeKRsn
'' SIG '' xPavMwGv8s5BMoz5XWNabMmZe8Ik2k6MYYlbvkSEaDQ6
'' SIG '' PnEVvASzwMcbEl44t/n6is15ukCmxO0skVj0wFBSJvjm
'' SIG '' FH1ajm4N33SMHgJ1sBK5xu7ycDJckbuvPTpLNNtdQ5GL
'' SIG '' sEgNJcvARxaMg3FoghNvsVhnw9L1J5tstf37OP5nNrj1
'' SIG '' 1E4JkfQpRxbjVHCGAA+kKgQvhgIfED2DIxGmXMXnyW00
'' SIG '' krb/Ia9F47r+V2ESAEXCtijtqUU+xg9CPw==
'' SIG '' End signature block
